package com.ejie.p06b.dokusi;

import java.net.URL;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.p06b.log.P06BLog;
//adriimport log.r76bCLog;

//adriimport org.slf4j.Logger;
//adriimport org.slf4j.LoggerFactory;

//import util.r76bCParametros;
import com.ejie.p06b.util.P06BParametros;

//import com.ejie.r76b.dokusi.wsclient.T65BFSDWSClasePort;
//import com.ejie.r76b.dokusi.wsclient.T65BFSDWSClasePortQSService_Impl;

import com.ejie.aa87b.t65bFsd.wsclient.T65BFSDWSClasePort;
//import com.ejie.aa87b.t65bFsd.wsclient.T65BFSDWSClasePortQSService_Impl;
import com.ejie.aa87b.t65bFsd.wsclient.T65BFSDWSClasePortQSService;

import com.ejie.t65.jaxb.beans.fsd.T65AttributeListType;
import com.ejie.t65.jaxb.beans.fsd.T65ConditionListType;
import com.ejie.t65.jaxb.beans.fsd.T65ContentType;
import com.ejie.t65.jaxb.beans.fsd.T65DocumentType;
import com.ejie.t65.jaxb.beans.fsd.T65StringListType;

public class P06bClienteDokusi {



	private static final Logger logger = LoggerFactory.getLogger(P06bClienteDokusi.class);

	/*
	 * Constructor privado (evitar error checkstyle)
	 */
	private P06bClienteDokusi() {
	}

	/**
	 * 
	 * @param strToken
	 *            Token de xlnets a pasar al servicio
	 * @param strAuditUser
	 *            Valor de campo auditUser a pasar al servicio
	 * @param strOid
	 * @param content
	 * @param keysList
	 * @return
	 */
	public static T65DocumentType fncRetrieveDocument(String strToken,
			String strAuditUser, String strOid, T65ContentType content,
			T65StringListType keysList) {
		// p43wClsLog.info("En P43BClienteDokusi.fncRetrieveDocument");
		try {
			P06BLog.send(2,"P06bClienteDokusi", "fncRetrieveDocument inicio");
			P06BLog.send(2,"P06bClienteDokusi", "strAuditUser: " + strAuditUser);
			P06BLog.send(2,"P06bClienteDokusi", "strOid: " + strOid);
			logger.info("fncRetrieveDocument inicio");
			logger.info("strAuditUser: " + strAuditUser);
			logger.info("strOid: " + strOid);

			if ("".equals(strAuditUser)) {
				strAuditUser = obtenerAuditUserDefecto(strAuditUser);
			}
			// Parsea objetos a cadenas
			String paramStrContent = null;
			if (content != null) {
				paramStrContent = P06bDokusiXMLBeanParserConverter
						.parseToStringContent(content);
			}
			String paramStrOid = P06bDokusiXMLBeanParserConverter
					.parseToStringDocumentID(strOid);
			String paramStrKeysList = P06bDokusiXMLBeanParserConverter
					.parseToStringStringList(keysList);

			P06BLog.send(2,"P06bClienteDokusi", "fncRetrieveDocument llamada");
			P06BLog.send(2,"P06bClienteDokusi", "strToken: " + strToken);
			P06BLog.send(2,"P06bClienteDokusi", "strAuditUser: " + strAuditUser);
			P06BLog.send(2,"P06bClienteDokusi", "paramStrOid: " + paramStrOid);
			P06BLog.send(2,"P06bClienteDokusi", "paramStrKeysList: " + paramStrKeysList);
			P06BLog.send(2,"P06bClienteDokusi", "paramStrContent: " + paramStrContent);
			logger.info("fncRetrieveDocument llamada" + strToken);
			logger.info("strToken: " + strToken);
			logger.info("strAuditUser: " + strAuditUser);
			logger.info("paramStrOid: " + paramStrOid);
			logger.info("paramStrKeysList: " + paramStrKeysList);
			logger.info("paramStrContent: " + paramStrContent);
			T65BFSDWSClasePort port = getPort();
			String strXmlResp = port.retrieveDocument(strToken, strAuditUser,
					paramStrOid, paramStrKeysList, paramStrContent);
			logger.info("Respuesta retrieveDocument: " + strXmlResp);
			P06BLog.send(2,"R76bClienteDokusi", "Respuesta retrieveDocument: : " + strXmlResp);
			// Parsea con los xmlbeans del jar de Dokusi, para devolver objeto
			T65DocumentType objResp = P06bDokusiXMLBeanParserConverter
					.parseToT65BDocument(strXmlResp);

			logger.info("fncRetrieveDocument fin");
			P06BLog.send(2,"R76bClienteDokusi", "fncRetrieveDocument fin" );
			return objResp;
		} catch (Exception e) {
			logger.error("fncRetrieveDocument: " + e.getMessage());
			P06BLog.send(2,"R76bClienteDokusi", "fncRetrieveDocument" + e.getMessage());
			return null;
		}
	}

	public static String fncSearchDocumentsFullText(String strToken,
			String strAuditUser, T65StringListType returnedAttributeKeysList,
			T65ConditionListType searchConditionsList,
			T65AttributeListType searchParamsList) {

		try {
//			logger.info("fncSearchDocumentsFullText inicio");
//			logger.info("strAuditUser: " + strAuditUser);
//			logger.info("searchConditionsList: " + searchConditionsList);
//			
//			logger.error("fncSearchDocumentsFullText inicio");
//			logger.error("strAuditUser: " + strAuditUser);
//			logger.error("searchConditionsList: " + searchConditionsList);
			if ("".equals(strAuditUser)) {
				strAuditUser = obtenerAuditUserDefecto(strAuditUser);
			}

			String strReturnedAttributeKeysList = P06bDokusiXMLBeanParserConverter
					.parseToStringStringList(returnedAttributeKeysList);
			String strSearchConditionsList = P06bDokusiXMLBeanParserConverter
					.parseToStringCondition(searchConditionsList);
			String strSearchParamsList = P06bDokusiXMLBeanParserConverter
					.parseToStringAttribute(searchParamsList);

			T65BFSDWSClasePort port = getPort();
			String strXmlResp = port.searchDocumentsFullText(strToken,
					strAuditUser, strReturnedAttributeKeysList,
					strSearchConditionsList, strSearchParamsList, 999);

			String oids = P06bDokusiXMLBeanParserConverter
					.getDocumentOids(strXmlResp);
			if (oids.length() == 0)
				oids = "0";
//			logger.info("oids: " + oids);
//			logger.info("fncSearchDocumentsFullText fin");
//			logger.error("fncSearchDocumentsFullText fin");
//			logger.error("oids: " + oids);
			return oids;
		} catch (Exception e) {

			// p43wClsLog.error("Excepcion fncRetrieveDocument", e);
			return "0";
		}
	}

	private static String obtenerAuditUserDefecto(String strAuditUser) {
		return P06bDokusiUtiles.obtenerAuditUserDefecto(strAuditUser);
	}

	private static T65BFSDWSClasePort getPort() throws Exception {
		String urlWS = P06BParametros.get("clienteDokusiUrl");
		 URL UurlWS = new URL(urlWS);

		//T65BFSDWSClasePortQSService_Impl objService = new T65BFSDWSClasePortQSService_Impl(urlWS);
		T65BFSDWSClasePortQSService objService = new T65BFSDWSClasePortQSService(UurlWS, new QName("http://www.ejie.es/webServiceClase/t65bFSDWar", "t65bFSDWSClasePortQSService"));
		
		T65BFSDWSClasePort port = objService.getT65BFSDWSClasePortQSPort();

		return port;
	}
}
